/**
* \file: WaylandFacade.h
*
* \version: 0.4
*
* \release: $Name:$
*
* Main interaction point with the individual SPI components, simplifies
* the use of Wayland
*
* \component: Unified SPI
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef USPI_WAYLAND_FACADE_H
#define USPI_WAYLAND_FACADE_H

#include <memory>
#include <wayland-client-protocol.h>
#include <uspi/EndpointDataSharing.h>
#include <uspi/ITouchFacade.h>

namespace adit { namespace uspi {

class WaylandConnection;

/** @class  WaylandFacade
 *  @brief  Facade to simplify Wayland use for touch.
 */
class WaylandFacade : public ITouchFacade, public SharedDataReceiver
{
public:
    WaylandFacade(void* inSessionCtx);
    ~WaylandFacade();

    /* Configuration parameters */
    WaylandFacade* setDisplaySize(int inDisplayWidth, int inDisplayHeight);
    WaylandFacade* setFingerNum(int inMaxFingerNum);

    /* ITouchFacade implementation */
    bool initialize(ITouchFacadeCallbacks* inCallbacks);
    bool deinitialize();

    bool connect();
    bool disconnect();

protected:
    /* SharedDataReceiver implementation */
    void onSurfaceDataProvided(wl_display* inWlDisplay);
    void onSurfaceDataExpired();
    void onResolutionDataProvided(int inWidth, int inHeight, int inMarginX, int inMarginY);

private:
    ITouchFacadeCallbacks* mCallbacks;
    std::unique_ptr<WaylandConnection> mWlConnection;

    wl_display* mWlDisplay; // @var to align with GStreamer

    int mDisplayWidth;
    int mDisplayHeight;
    int mMaxFingerNum;

    bool mConnected;
};

} } /* namespace adit { namespace uspi { */

#endif /* USPI_WAYLAND_FACADE_H */
